<?php
//
include("init.php");

/**
 *	配布ファイル一覧の表示
 *	@param $curPath  配布ファイル保存フォルダ
 *	@param $rm_on    削除ボタン 1:表示 0:非表示
 *	@return なし
 */
function listing_files($curPath, $rm_on) {
	$filelist = array();
        $i=0;
	$d=dir($curPath);
	while($entry=$d->read()){
		if ($entry!="." && $entry!=".."){
			$strTmp=$curPath."/".$entry;
			$aryInfo=pathinfo($strTmp);
///// UTF-8の日本語の長いファイル名が削除できない
/////			$btName = str_replace(".","-",$entry);
			$btName = "FILE" . $i; $i++;

			if (isset($_POST["$btName"])) {  // 削除ボタンが押された
				print($strTmp);
				unlink($strTmp);
				$comfile = $curPath . "/memo/" . $entry;
				if (file_exists($comfile)) // コメントがあれば削除
				unlink($comfile);
				print_message("削除しました");
			} else {
				if (!is_dir($strTmp)) // ディレクトリでなければ
				// 更新日時、　ファイルパス、　ファイル名、ファイルサイズ、削除ボタン名
				$filelist[] = filemtime($strTmp). ",". $strTmp. ",". $entry. ",". filesize($strTmp). ",". $btName;
			}
		}
	}
	$d->close();
	$n = count($filelist);
	if ($n > 0) {
		rsort($filelist);
		print('<TABLE border="1"><tr>');
		print("<TH colspan=" . ($rm_on + 1) . ">ファイル名</TH><TH>サイズ</TH><TH>コメント</TH><TH>最終更新日</TH></TR>\n");
		for ($i = 0; $i < $n; $i++) {
			$val = explode(",", $filelist[$i]); /* カンマで分割 */
			print("<TR><TD><A href='$val[1]'>$val[2]</A></TD>");
			if ($rm_on == 1) // 削除ボタンあり
			print('<TD><INPUT type="submit" value="削除" name="' . $val[4] . '"></TD>');
			print("<TD align='right'>".round($val[3]/1024)."KB</TD>");
			$comfile = $curPath ."/memo/" . $val[2];
			if (file_exists($comfile)) { // コメントがあれば表示
				print("<TD>");
				readfile($comfile);
				print("</TD>");
			} else print("<TD>　</TD>");
			print("<TD>".date("Y/m/d H:i:s",$val[0])."</TD>");
			print("</TR>");
		}
		print("</TABLE>\n");
	}  else  print_error("配布ファイルはありません");
}
?>
