<?php
$gFile = "glossary.csv";    // 書き込みログファイル

/**
 *	新規用語入力エリアの表示
 */
function new_word_area() {
	print_title1("新規用語");
	print("<TABLE border='1'>");
	print("<TR><TH><FONT color='BLUE'>登録者：</FONT></TH><TD>" . $_SESSION['user'] . "</TD></TR>");
	print("<INPUT type='hidden' name='xname' value='" . $_SESSION['user'] . "'>");
	print("<TR><TH><FONT color='BLUE'>用語：</FONT></TH><TD><INPUT type='text' size='110' name='word'></TD></TR>");
	print("<TR><TH><FONT color='BLUE'>意味：</FONT></TH><TD><TEXTAREA rows=5 cols=80 name='mean'></TEXTAREA></TD></TR>");
	print("</TABLE>");
	print("<INPUT type='submit' value='書込み' name='write'>");
	print("<HR>\n");
}

//  用語の表示
/**
 *	用語をソート
 *	@param $v1 用語1
 *	@param $v2 用語2
 *	@return 比較結果
 */
function wordcmp($v1, $v2) { // ソート関数
   $w1 = explode(",",$v1);
   $w2 = explode(",",$v2);
   return strcasecmp($w1[2], $w2[2]);
}

/**
 *	用語一覧の表示
 *	@param $mode 表示モード 0:普通モード 1:削除ボタンあり
 */
function words_view($mode) {
	global $gFile;

	$m = NULL;  // 削除されたかも知れないので読み直し
	$m = file($gFile);
	$n = count($m);
	if ($n == 0) print_error("現在書き込みはありません");
	else {
		for ($i = 0; $i < $n; $i++) { // 読み込み 
			$tmp = chop($m[$i]);  // 行末の改行文字を取り除く
                        $m[$i] = $tmp . ",$i";  // 最後に行番号追加
                }
                usort($m, "wordcmp");  // 用語でソート
                for ($i = 0; $i < $n; $i++) {
                        $data = NULL;
			$data = explode(",", $m[$i]);

			$k = $i + 1;      // 用語番号
			print("\n<DIV align='left'>$k : ---------------------------</DIV>");
			if ($data[0][0] == "x") //   削除マークなら
			print("削除されました<BR>\n");
			else {
				// 書き込みログの表示
				print("<TABLE border=1>");
				print("<TR><TH><FONT color='BLUE'>【用語】</FONT></TH><TH align='left'><FONT color='RED'>$data[2]</FONT></TH></TR>");
				print("<TR><TH><FONT color='BLUE'>【意味】</FONT>");
				if ($mode == 1) // 削除あり
				print("<BR><INPUT type='SUBMIT' name='del" . $data[4] . "' value='削除'>");
				print("</TH><TD width='600'>$data[3]</TD></TR>");
				print("<TR><TD colspan='2' align='right'><FONT color='BLUE'>【登録日時】</FONT>$data[0]");
				print("<FONT color='BLUE'>　【登録者】</FONT>$data[1]</TD></TR>");
				print("</TABLE>\n");
			}
		}
	}
}
?>
