<?php
//  管理者用
//    パスワードの削除
session_start();
include("../param.inc");

/**
 *	ユーザ一覧の表示
 *	@param $no    出席番号の配列
 *	@param $id    ユーザIDの配列
 *	@param $uname 氏名の配列
 */
function listing_user($no, $id, $uname) {
	global $passdir;

	$filelist = NULL;

	$n = count($id);
	for ($i = 0; $i < $n; $i++) {
		$uid = $id[$i];
		if (isset($_POST[$uid])) {  // 削除ボタンが押された
			unlink($passdir . $uid);
			print("<P><STRONG>$uid</STRONG>のパスワードを削除しました</P>");
		}
		if (file_exists($passdir . $uid)) {// 出席番号，ログイン名，氏名，最終変更日，削除ボタン
			$passwdlist[] = "$no[$i],$uid,$uname[$i]," . date("Y-m-d", filemtime($passdir . $uid)) . ",$uid";
		} else {    // 出席番号，ログイン名，氏名,,
			$passwdlist[] = "$no[$i],$uid,$uname[$i],,";
		}
	}
	print("<TABLE border='1'>");
	print("<TR>");
	print("<TH>No</TH><TH>ログイン名</TH><TH>氏   名</TH><TH>最終変更日</TH><TH>削除</TH>");
	print("</TR>");

	$n = count($passwdlist);  // ユーザ数
	for ($i = 0; $i < $n; $i++) {
		$val = explode(",", $passwdlist[$i]); /* カンマで分割 */
		print("<TR>");
		print("<TD nowrap>$val[0]</td>");
		print("<TD nowrap>$val[1]</td>");
		print("<TD nowrap>$val[2]</td>");
		print("<TD nowrap>$val[3]</td>");
		if ($val[4] != "") { // パスワードが設定されている
			print("<TD><INPUT type='submit' value='削除' name='$val[4]'></TD>");
		}
		print("</TR>");
	}
	println("</TABLE>");
}

print_header("管理");
if (!isset($_SESSION['id']) || ($_SESSION['id'] == "")) { // ログインしていない
	print("<SCRIPT language='JavaScript'>");
	print("window.alert('ログインしてください');");
	print("</SCRIPT>");
	print("<CENTER><A href='../main/index.php'>ログインページへ</A></CENTER>");
} else if ($_SESSION['admin']==0) { // 管理者でない
	print("<SCRIPT language='JavaScript'>");
	print("window.alert('あなたな管理者ではありません');");
	print("</SCRIPT>");
} else {
	print_headline("パスワードの初期化・削除"); 
	print_title1("学習者とパスワード情報");
	?>

<FORM method="POST" action="deletepasswd.php">
<CENTER>初期パスワード：<INPUT type="text" name="inipas" size="10"> 管理者以外：<INPUT
	type="submit" value="初期化" name="init"> <?php
	if (isset($_POST['init'])) { // 初期化ボタンが押されたとき
		if ($_POST['inipas'] == "") print_error("初期パスワードが入力されていません");
		else {
			$n = count($_SESSION['no']);  // ユーザ数
			for ($i = 0; $i < $n; $i++) {
				if ($_SESSION['no'][$i] > 0) { // 学習者なら初期化
					$file = fopen($passdir . $_SESSION['uid'][$i], "w");
					fwrite($file, md5($_POST['inipas']));  // 新しいパスワードを書き込む
					fclose($file);
				}
			}
			print_message("管理者以外のパスワードを初期化しました");
		}
	}
	print("<BR><BR>");
	listing_user($_SESSION['no'], $_SESSION['uid'], $_SESSION['uname']);  /* ユーザ一覧表示 */
	print("</CENTER>");
	print("</FORM>");
} print_copyright();
?>
</BODY>
</HTML>