<?php
//   簡易e-ラーニングシステム EL（エル） レポートのハイライト表示付
//
// 共通パラメータ
include("el.ini");
date_default_timezone_set('Asia/Tokyo');

/////////////////////  以下は変数の意味が理解できるまで変更しないで下さい。
$mimetexPATH = "/cgi-bin/mimetex.cgi?";            // mimetex のインストール先
$geshiPATH = "../../geshi/geshi.php"; // geshi のインストール先
$fckeditorPATH = "/ckeditor/"; // ckeditor のインストール先

$IDlength = 6;                         // ユーザＩＤの文字数（固定長）
// main/index.php で使用するLDAP関係のパラメータ
$LDAP_SERVER = "";   // LDAPサーバ
$LDAP_BASE_DN = ""; // LDAPのディレクトリのベース DN 
/////////////////////
/**
 *	サイドメニューの表示
 *	@param $filepath    メニューファイル
 */
function show_side_menu($filepath)
{
     print(file_get_contents($filepath));
}


$meibo = "../" . $Student;     // 学生名簿
$passdir = "../pas/";          // パスワードのディレクトリ

/**
 *	学生情報の読み込み
 */
function read_users_info() {
	global $meibo;
	$fp = fopen($meibo, "r");
	$no_id = NULL;
	$uname_id = NULL;
	$no = NULL;
	$uid = NULL;
	$uname = NULL;
////////////////////////////////////  氏名が UTF-8 ではうまくいかない
// while ($stmp = fgetcsv($fp,100)) {
//    $no_id[$stmp[3]] = $stmp[2];       //   番号[id]
//    $uname_id[$stmp[3]] = $stmp[4];    //   氏名[id]
//    $no[] = $stmp[2];
//    $uid[] = $stmp[3];
//    $uname[] = $stmp[4];
// }
///////////////////////////////////////////////////////////////
	while (!feof($fp)) {
		$tmp = chop(fgets($fp,255));
		if ($tmp != "") {
			$stmp=explode(",", $tmp);
			$no_id[$stmp[3]] = $stmp[2];       //   番号[id]
			$uname_id[$stmp[3]] = $stmp[4];    //   氏名[id]
                        $id_no[$stmp[2]] = $stmp[3];    //   id[番号]
			$no[] = $stmp[2];                    //   番号[連番]
			$uid[] = $stmp[3];                    //   id[連番]
			$uname[] = $stmp[4];                 //   氏名[連番]
		}
	}

	fclose($fp);
	$_SESSION['no_id'] = $no_id;
	$_SESSION['uname_id'] = $uname_id;
        $_SESSION['id_no'] = $id_no;
	$_SESSION['no'] = $no;
	$_SESSION['uid'] = $uid;
	$_SESSION['uname'] = $uname;

}

/**
 *	受講学生の確認
 *	@param $id    ログインID
 *	@return 出席番号（負の数は管理者）
 */
function is_student($id) {
  if (isset($_SESSION['no_id'][$id])) return $_SESSION['no_id'][$id];
  else return 0;
}
/**
 *	受講学生の確認
 *	@param $meibo 学生名簿のファイル名
 *	@param $id    ログインID
 *	@return 出席番号（負の数は管理者）
 */
/*
function is_student($meibo, $id) {
	$find = 0;
	$fp = fopen($meibo, "r");
	while ($stmp = fgetcsv($fp,100)) {
		if ($id == $stmp[3]) {
			$find = $stmp[2];  // 番号
			break;
		}
	}
	fclose($fp);
	return $find;
}
*/
/**
 *	出席番号順にソート
 *	@param $val1    データ1
 *	@param $val2    データ2
 *	@return 比較結果（1,0,-1）
 */
function sort_by_no($val1, $val2) {
	$v1 = explode(",", $val1);
	$v2 = explode(",", $val2);
	if ($v1[0] > $v2[0]) return 1;
	else if ($v1[0] == $v2[0]) return 0;
	else return -1;
}

/**
 *	出席番号,ファイル名順にソート
 *	@param $val1    データ1
 *	@param $val2    データ2
 *	@return 比較結果（1,0,-1）
 */
function sort_by_no_report($val1, $val2) {
	$v1 = explode(",", $val1);
	$v2 = explode(",", $val2);
	if ($v1[0] > $v2[0]) return 1;
	else if ($v1[0] == $v2[0]) {
		if ($v1[2] > $v2[2]) return 1;
		else return -1;
	}
	else return -1;
}

// 各種出力用関数

/**
 *	文字列を改行付きで出力
 *	@param $str     出力文字列
 *	@return なし
 */
function println($str) {
	printf("%s\n", $str);
}

/**
 *	エラーを赤字で出力
 *	@param $str     エラー文字列
 *	@return なし
 */
function print_error($str) { // エラーや注意を促すメッセージ出力
	println("<BR><FONT color='#FF0000'><STRONG> $str </STRONG></FONT><BR>");
}

/**
 *	文字列を青字で出力
 *	@param $str     出力文字列
 *	@return なし
 */
function print_message($str) { // 通常のメッセージ出力
	println("<BR><FONT color='#0000FF'><STRONG> $str </STRONG></FONT><BR>");
}

/**
 *	ログイン後のヘッダ部分を出力
 *	@param $text     小見出し
 *	@return なし
 */
function print_headline($text) {    // ログイン後
	global $Title;

	print("<CENTER><TABLE><TR><TH nowrap width=600 bgcolor='YELLOW'><FONT size='+1' color='BLUE'> $Title </FONT></TH></TR>");
	print("<TR><TH nowrap bgcolor=");
	if ($_SESSION['admin'] == 1) print("'RED'");   // 管理者
	else                         print("'BLUE'");  // 学習者
	print("><FONT size='+1' color='WHITE'> $text </FONT></TH></TR></TABLE></CENTER>");
	if (isset($_SESSION['id'])) { // user がセッション変数で
		if ($_SESSION['id'] != "") { // ログインしていれば
			print('<FORM method="POST" action="../main/index.php">');
			print("<DIV align='right'>LOGIN:<FONT color='BLUE'>" . $_SESSION['user'] . "</FONT>");
			print('<INPUT type=submit name="logout" value="ログアウト">');
			if ($_SESSION['admin'] == 1) // 管理者
			print('・<A href="../main/admin.php">トップページ</A>');
			else                         // 学習者
			print('・<A href="../main/student.php">トップページ</A>');
			print('</DIV>');
			println('</FORM>');
		}
	}
	println("<HR size='5'>");
}

/**
 *	ログイン前のヘッダ部分を出力
 *	@param $text     小見出し
 *	@return なし
 */
function print_headline_top($text) {     // ログイン前
	global $Title;

	println("<CENTER><TABLE><TR><TH nowrap width=600 bgcolor='YELLOW'><FONT size='+1' color='BLUE'> $Title </FONT></TH></TR>");
	println("<TR><TH nowrap bgcolor='GREEN'><FONT size='+1' color='WHITE'> $text  </FONT></TH></TR></TABLE></CENTER>");
	print("<DIV align='right'><A href='../changes.html'>更新履歴</A></DIV>");
	println("<HR size='5'>");
}

/**
 *	改行を<BR>タグに置換
 *	@param $str     置換前の文字列
 *	@return         置換後の文字列
 */
function ret_replace($str) {  // 改行を<BR>タグに置換
	$tmp = htmlspecialchars(mb_convert_encoding($str, "UTF-8","auto"),ENT_COMPAT,"UTF-8");
	$str1 = str_replace("\r\n", "<BR>", $tmp);
	$tmp = str_replace("\n", "<BR>", $str1);
	return $tmp;
}

/**
 *	文字コードをサーバの文字コードに変更する（特殊文字も変換）
 *	@param $str     置換前の文字列
 *	@return         置換後の文字列
 */
function html_convert($str) {
	return htmlspecialchars(jcode_convert($str),ENT_COMPAT,"UTF-8");
}

/**
 *	文字コードをサーバの文字コードに変更する
 *	@param $str     置換前の文字列
 *	@return         置換後の文字列
 */
function jcode_convert($str) {
	// エスケープされている場合\文字を削除する
	if (get_magic_quotes_gpc() == 1) // POSTがエスケープされている
	$str1 = stripslashes(mb_convert_encoding($str, "UTF-8","auto"));
	else
	$str1 = mb_convert_encoding($str, "UTF-8","auto");
	return $str1;
}

/**
 *	本文中の第1タイトルの表示
 *	@param $str     第1タイトル
 *	@return なし
 */
function print_title1($str) {
	println("<CENTER><TABLE border=0 cellpadding=5><TR><TH width=300 bgcolor='#99FF99'><FONT color='#990099'> $str </FONT></TH></TR></TABLE></CENTER>");
}

/**
 *	本文中の第2タイトルの表示
 *	@param $str     第2タイトル
 *	@return なし
 */
function print_title2($str) {
	println("<HR><TABLE border=0 cellpadding=5><TR><TH width=300 bgcolor='#800080'><FONT color='WHITE'> $str </FONT></TH></TR></TABLE>");
}

/**
 *	HTMLヘッダの表示
 *	@param $sub     サブタイトル
 *	@return なし
 */
function print_header($sub) { // HTMLヘッダの表示
	global $Title;

	print("<HTML>");
	print("<HEAD>");
	print("<META http-equiv='Content-Type' content='text/html; charset=UTF-8'>");
	print("<TITLE>" . $Title);
	if ($sub != "") print(" - " . $sub);
	print("</TITLE>");
	print("<LINK href='../style.css' rel='stylesheet' type='text/css'>");
	print("</HEAD>");
	print("<BODY>");
}

/**
 *	数式 をmimetex.cgi呼出しに変換
 *	@param $str     数式 形式の文字列
 *	@return         mimetex.cgi呼出しの文字列
 */
function exp_change($str) {
	global $mimetexPATH;

	$n = mb_strlen($str);  // 文字数
	//
	$e = $str;
	$str2 = "";

	for ($i=0; $i<$n; $i++) {
		if (($c = mb_substr($str, $i, 1)) != '#') // 区切り文字でなければ
		$str2 = $str2 . $c;
		else {     // 数式文字列の処理
			$e = "";
			$i++;
			for (;  (($c = mb_substr($str, $i, 1)) != '#') && ($i < $n); $i++)
			$e = $e . $c;
			if ($c != '#') {
				print("数式の対応が一致しません");
				return "エラー";
			} else
			$str2 = $str2 . '<img src="' . $mimetexPATH . $e . '">';
			//debug            $str2 = $str2 . '<font color="blue">' . $e . '</font>';
		}
	}
	return $str2;
}

/**
 *	課題等説明の表示
 *	@param $File     課題説明のファイル名
 *	@return なし
 */
function print_problem($File) {
	if (file_exists($File)) {      // 課題説明ファイルがあれば
		$file = fopen($File, "r");
		$days = NULL;
		$days = fgetcsv($file, 255);
		$text = jcode_convert(fread($file, filesize($File)));  // 説明文
		fclose($file);
		print("<H4>締切 $days[0] 月 $days[1] 日</H4>\n");
		print(ret_replace($text));
	}
}

/**
 *	コピーライトの表示
 */
function print_copyright() {
	println("<HR><CENTER>Copyright(C) 2006-2015 Akiyoshi Miyatake. All Rights Reserved.(" . date("Y/m/d", filemtime("../changes.html")) . ")</CENTER>");
}
?>
