<?php
$pchart_PATH = "../../pChart2.1.4/";    // pChartの場所
$FontName = $pchart_PATH . "fonts/ipagp.ttf"; // 日本語フォント名
/* pChart library inclusions */
include($pchart_PATH . "class/pData.class.php");
include($pchart_PATH . "class/pDraw.class.php");
include($pchart_PATH . "class/pRadar.class.php");
include($pchart_PATH . "class/pPie.class.php");
include($pchart_PATH . "class/pImage.class.php");

// 棒グラフ
function bar($label, $data, $png)
{
  global $pchart_PATH, $FontName;
$myData = new pData();
$myData->addPoints($data,"Serie1");
// $myData->setSerieDescription("Serie1","Serie 1");
// $myData->setSerieOnAxis("Serie1",0);

$myData->addPoints($label,"Absissa");
$myData->setAbscissa("Absissa");

// $myData->setAxisPosition(0,AXIS_POSITION_LEFT);
// $myData->setAxisName(0,"1st axis");
$myData->setAxisUnit(0,"");
$hight = 50 + count($label)*20;
$width = 600;
$myPicture = new pImage($width,$hight,$myData);
// $Settings = array("R"=>170, "G"=>183, "B"=>87, "Dash"=>1, "DashR"=>190, "DashG"=>203, "DashB"=>107);
// $myPicture->drawFilledRectangle(0,0,700,230,$Settings);

// $Settings = array("StartR"=>219, "StartG"=>231, "StartB"=>139, "EndR"=>1, "EndG"=>138, "EndB"=>68, "Alpha"=>50);
// $myPicture->drawGradientArea(0,0,700,230,DIRECTION_VERTICAL,$Settings);

$myPicture->drawRectangle(0,0,$width-1,$hight-1,array("R"=>0,"G"=>0,"B"=>0));

// $myPicture->setShadow(TRUE,array("X"=>1,"Y"=>1,"R"=>50,"G"=>50,"B"=>50,"Alpha"=>20));

$myPicture->setFontProperties(array("FontName"=>$FontName,"FontSize"=>14));
// $TextSettings = array("Align"=>TEXT_ALIGN_MIDDLEMIDDLE, "R"=>255, "G"=>255, "B"=>255);
// $myPicture->drawText(350,25,"はじめての pChart プロジェクト",$TextSettings);

$myPicture->setShadow(FALSE);
$myPicture->setGraphArea(120,30,$width-5,$hight-5);
$myPicture->setFontProperties(array("R"=>0,"G"=>0,"B"=>0,"FontName"=>$FontName,"FontSize"=>8));

$Settings = array("Pos"=>SCALE_POS_TOPBOTTOM
, "Mode"=>SCALE_MODE_ADDALL_START0
, "LabelingMethod"=>LABELING_ALL
, "GridR"=>255, "GridG"=>255, "GridB"=>255, "GridAlpha"=>50, "TickR"=>0, "TickG"=>0, "TickB"=>0, "TickAlpha"=>50, "LabelRotation"=>0, "CycleBackground"=>1, "DrawXLines"=>1, "DrawSubTicks"=>1, "SubTickR"=>255, "SubTickG"=>0, "SubTickB"=>0, "SubTickAlpha"=>50, "DrawYLines"=>ALL);
$myPicture->drawScale($Settings);

$myPicture->setShadow(TRUE,array("X"=>1,"Y"=>1,"R"=>50,"G"=>50,"B"=>50,"Alpha"=>10));

$Config = array("AroundZero"=>1);
$myPicture->drawBarChart($Config);

// 凡例を表示
// $Config = array("FontR"=>0, "FontG"=>0, "FontB"=>0, "FontName"=>$FontName, "FontSize"=>6, "Margin"=>6, "Alpha"=>30, "BoxSize"=>5, "Style"=>LEGEND_NOBORDER
// , "Mode"=>LEGEND_HORIZONTAL
// );
// $myPicture->drawLegend(647,16,$Config);

$myPicture->Render($png);
}

// レーダーチャート
function radar($label, $data, $png)
{
  global $pchart_PATH, $FontName;

/* Create and populate the pData object */
$MyData = new pData();   
$MyData->addPoints($data,"Score");  
$MyData->setSerieDescription("Score","Application A");
$MyData->setPalette("Score",array("R"=>157,"G"=>196,"B"=>22));

/* Define the absissa serie */
$MyData->addPoints($label,"Families");
$MyData->setAbscissa("Families");

/* Create the pChart object */
$myPicture = new pImage(300,300,$MyData);
// $myPicture->drawGradientArea(0,0,300,300,DIRECTION_VERTICAL,array("StartR"=>200,"StartG"=>200,"StartB"=>200,"EndR"=>240,"EndG"=>240,"EndB"=>240,"Alpha"=>100));
// $myPicture->drawGradientArea(0,0,300,20,DIRECTION_HORIZONTAL,array("StartR"=>30,"StartG"=>30,"StartB"=>30,"EndR"=>100,"EndG"=>100,"EndB"=>100,"Alpha"=>100));
// $myPicture->drawLine(0,20,300,20,array("R"=>255,"G"=>255,"B"=>255));
$RectangleSettings = array("R"=>180,"G"=>180,"B"=>180,"Alpha"=>100);

/* Add a border to the picture */
$myPicture->drawRectangle(0,0,299,299,array("R"=>0,"G"=>0,"B"=>0));

/* Write the picture title */ 
// $myPicture->setFontProperties(array("FontName"=>$FontName,"FontSize"=>10));
// $myPicture->drawText(10,15,"質問ごとの評価",array("R"=>255,"G"=>255,"B"=>255));

/* Set the default font properties */ 
$myPicture->setFontProperties(array("FontName"=>$FontName,"FontSize"=>10,"R"=>80,"G"=>80,"B"=>80));

/* Enable shadow computing */ 
$myPicture->setShadow(TRUE,array("X"=>2,"Y"=>2,"R"=>0,"G"=>0,"B"=>0,"Alpha"=>10));

/* Create the pRadar object */ 
$SplitChart = new pRadar();

/* Draw a radar chart */ 
$myPicture->setGraphArea(10,25,290,290);

// トップから書くようにAxisRotationを設定
$Options = array("AxisRotation"=>-90,"DrawPoly"=>TRUE,"WriteValues"=>FALSE,"ValueFontSize"=>8,"Layout"=>RADAR_LAYOUT_CIRCLE,"BackgroundGradient"=>array("StartR"=>255,"StartG"=>255,"StartB"=>255,"StartAlpha"=>100,"EndR"=>207,"EndG"=>227,"EndB"=>125,"EndAlpha"=>50));
$SplitChart->drawRadar($myPicture,$MyData,$Options);

/* Render the picture (choose the best way) */
$myPicture->Render($png);
//$myPicture->Stroke();
}

// 3Dパイチャート
function pie3d($label, $data, $png)
{
  global $pchart_PATH, $FontName;

/* Create and populate the pData object */
$MyData = new pData();   
$MyData->addPoints($data,"ScoreA");  
$MyData->setSerieDescription("ScoreA","Application A");

/* Define the absissa serie */
$MyData->addPoints($label,"Labels");
$MyData->setAbscissa("Labels");

/* Create the pChart object */
$myPicture = new pImage(300,260,$MyData);

/* Draw a solid background */
// $Settings = array("R"=>170, "G"=>183, "B"=>87, "Dash"=>1, "DashR"=>190, "DashG"=>203, "DashB"=>107);
// $myPicture->drawFilledRectangle(0,0,300,300,$Settings);

/* Overlay with a gradient */
// $Settings = array("StartR"=>219, "StartG"=>231, "StartB"=>139, "EndR"=>1, "EndG"=>138, "EndB"=>68, "Alpha"=>50);
// $myPicture->drawGradientArea(0,0,300,260,DIRECTION_VERTICAL,$Settings);
// $myPicture->drawGradientArea(0,0,300,20,DIRECTION_VERTICAL,array("StartR"=>0,"StartG"=>0,"StartB"=>0,"EndR"=>50,"EndG"=>50,"EndB"=>50,"Alpha"=>100));

/* Add a border to the picture */
$myPicture->drawRectangle(0,0,299,259,array("R"=>0,"G"=>0,"B"=>0));

/* Write the picture title */ 
// $myPicture->setFontProperties(array("FontName"=>$FontName,"FontSize"=>6));
// $myPicture->drawText(10,13,"pPie - Draw 3D pie charts",array("R"=>255,"G"=>255,"B"=>255));

/* Set the default font properties */ 
$myPicture->setFontProperties(array("FontName"=>$FontName,"FontSize"=>10,"R"=>80,"G"=>80,"B"=>80));

/* Create the pPie object */ 
$PieChart = new pPie($myPicture,$MyData);

/* Draw an AA pie chart */ 
$PieChart->draw3DPie(160,140,array("Radius"=>70,"DrawLabels"=>TRUE,"LabelStacked"=>TRUE,"Border"=>TRUE));

/* Write the legend box */ 
$myPicture->setShadow(FALSE);
$PieChart->drawPieLegend(15,40,array("Alpha"=>20));

/* Render the picture (choose the best way) */
$myPicture->Render($png);
}
?>
