<?php
/**
 *	質問のプレビュー
 *	@param $mPath 質問保存フォルダ
 *	@param $mFile 質問保存ファイル
 *	@return 質問数
 */
function quest_preview($mPath, $mFile) {
	global $sort_index;
	$nop = 0;

	if (!file_exists($mFile)) print_error("現在，質問がありません");
	else {
		$n = count($_SESSION['no']);   //  ユーザ数
		$data = NULL;
		for ($i=0; $i<$n; $i++) {
			$scorefile = "$mPath" . $_SESSION['uid'][$i];
			if (file_exists($scorefile)) {
				$fp = fopen($scorefile, "r");
				while ($tmp = fgets($fp, 4096)) $data[] = $tmp;  // 回答を取り込む
				fclose($fp);
			}
		}
		$n = count($data);
		if ($n > 0) {  // 回答があれば
			//  アンケート説明の表示
			print_problem($mPath . "problem.txt");

			$handle = fopen($mFile,"r");
			print("<TABLE border=1>");

			while(!feof($handle)) {  // EOFでない間
				$tmp = fgets($handle, 4096);
				$mondai=chop($tmp);    // 改行を削除
				if ($mondai != "") {
					$nop = $nop+1;        // 問題番号
					$kei = quest_preview_1($mPath, $nop, $mondai,$data);

				}
			}
			fclose($handle);
			print("</TABLE>\n");
			return $nop;  // 問題数を返す
		}
	}
}

/**
 *	質問（1問）のプレビュー
 *	@param $mPath 質問保存フォルダ
 *	@param $nop   質問番号
 *	@param $monda 質問格納文字列（カンマ区切り）
 *      @param $ans   回答格納文字列（カンマ区切り）
 *	@return $kei 質問形式（s:選択式, h:複数選択式, k:記述式, n:yes/no）
 */
function quest_preview_1($mPath, $nop, $mondai, $ans) {
	global $sort_index;
	$data = explode(",", $mondai);
	$pic = $data[0];   // 図
	$kei = $data[1];    // 問題形式
	$quiz = $data[2];   // 問題文

	//      print("Type: $type<BR>\n");
	print("<TR><TH colspan=2 bgcolor='BLUE'><FONT color='WHITE'>No: $nop </FONT></TH></TR>");
	print("<TR><TH nowrap>【質問】</TH><TD width='600'>" . exp_change($quiz));
	if (($pic != "") && (file_exists($mPath . $pic))) //  図の表示
	print("<BR><IMG src='" . $mPath . $pic . "'>");
	print("</TD></TR>\n");
//	print("<TR><TH>$nop</TH>");
	$q_content = NULL;    // 回答内容
	$q_count = NULL;      // 回答数
	$q_content[0] = "";
	$q_count[0] = 0;
	$sort_index = $nop + 2;
	usort($ans,"sort_by_ans");
	$ans_num = count($ans);   // 回答数
	for ($j = 0; $j < $ans_num; $j++) {
		$val = explode(",", $ans[$j]);
		if ($val[$sort_index] != $q_content[0]) {  // 新しい回答を登録
			$q_content[] = $val[$sort_index];
			$q_content[0] = $val[$sort_index];
			$q_count[] = 1;
		} else {
			$n = count($q_count);
			$q_count[$n-1] = $q_count[$n-1] + 1;
		}
	}
	$labels = NULL;
	$datas = NULL;
	// 選択
	if (($kei == "s") || ($kei == "h")) {
		print("<TR><TH nowrap>【選択】</TH><TD>");
		$select_num = count($data)-3;  // 選択肢の数
		for ($i=1; $i<=$select_num; $i++)
		if ($data[$i+2] != "") print("【" . $i. "】　" . exp_change($data[$i+2]) . "<BR>");
		print("</TD></TR>\n");
/////
		print("<TR><TD colspan='2'>\n");
		for ($j = 1; $j < count($q_content); $j++) {
//			print("$q_content[$j]：$q_count[$j]<BR>");
			$labels[]=$q_content[$j];
			$cont[]=$q_count[$j];
		}
		bar($labels, $cont, "$nop.png");
		print("<img src='$nop.png'>");
		print("</TD></TR>\n");
/////
	}
	// 記述問題
	if ($kei == "k") {
		print('<TR><TH nowrap>【記述】</TH><TD>');
/////
		for ($j = 1; $j < count($q_content); $j++)
			print("$q_content[$j]：$q_count[$j]<BR>");
		print("</TD></TR>\n");
/////
	}
	// yes-no問題
	if ($kei == "n") {
		print("<TR><TH nowrap>【選択】</TH><TD>");
//		print("$q_content[2]：$q_count[2]<BR>"); // はい
//		print("$q_content[1]：$q_count[1]<BR>"); // いいえ
//		print("</TD></TR>\n");
		$labels=array("はい","いいえ");
		$cont=array($q_count[2],$q_count[1]);
		bar($labels, $cont, "$nop.png");
		print("<img src='$nop.png'>");
	}
	return $kei;
}
?>
