﻿<?php
session_start();
include("../param.inc");
include_once("quest_preview.inc");
include('pchart-func.php');
  // 管理者用グラフ表示
$sort_index = 0;
/**
 *	回答ごとにソート
 *	@param $val1  データ1
 *	@param $val2  データ2
 *	@return 比較結果（1,0,-1）
 */
function sort_by_ans($val1, $val2) {
	global $sort_index;

	$v1 = explode(",", $val1);
	$v2 = explode(",", $val2);
	$n = strcmp($v1[$sort_index], $v2[$sort_index]);
	if ($n > 0) return 1;
	else if ($n == 0) return 0;
	else return -1;
}

/**
 *	回答集計を表示
 *	@param $path 回答保存フォルダ
 */
function save_allscore_counting($path) {
	global $sort_index;
	$n = count($_SESSION['no']);   //  ユーザ数
	$data = NULL;
	for ($i=0; $i<$n; $i++) {
		$scorefile = "$path/" . $_SESSION['uid'][$i];
		if (file_exists($scorefile)) {
			$fp = fopen($scorefile, "r");
			while ($tmp = fgets($fp, 4096)) $data[] = $tmp;  // 回答を取り込む
			fclose($fp);
		}
	}
	$n = count($data);
	if ($n > 0) {  // 回答があれば
		// 回答ごとに集計
		$val = explode(",", $data[0]); // カンマで分割
		$j = count($val);
		$quest_num = $j - 4;  // 質問数
                $label = array();// レーダーチャート用ラベル
                $ave = array();  // レーダーチャート用平均値
                $total = array(); // 合計
                $ninzu = array(); // 回答数
                $text_ans = array();   // 自由記入
		for ($i=1; $i <= $quest_num; $i++) { // 質問番号を出力
                        $total[$i] = 0;       // 初期化
                        $ninzu[$i] = 0;       // 初期化
			$q_content = NULL;    // 回答内容
			$q_count = NULL;      // 回答数
			$q_content[0] = "";
			$q_count[0] = 0;
			$sort_index = $i + 2;
			usort($data,"sort_by_ans");
			$ans_num = count($data);   // 回答数
			for ($j = 0; $j < $ans_num; $j++) {
				$val = explode(",", $data[$j]);
				if ($val[$i + 2] != $q_content[0]) {  // 新しい回答を登録
					$q_content[] = $val[$i + 2];
					$q_content[0] = $val[$i + 2];
					$q_count[] = 1;
				} else {
					$n = count($q_count);
					$q_count[$n-1] = $q_count[$n-1] + 1;
				}
			}
			for ($j = 1; $j < count($q_content); $j++) {
                           switch ($q_content[$j]) {
                             case "【1】": $total[$i] += $q_count[$j];
                                           $ninzu[$i] += $q_count[$j];
                                           break;
                             case "【2】": $total[$i] += 2*$q_count[$j];
                                           $ninzu[$i] += $q_count[$j];
                                           break;
                             case "【3】": $total[$i] += 3*$q_count[$j];
                                           $ninzu[$i] += $q_count[$j];
                                           break;
                             case "【4】": $total[$i] += 4*$q_count[$j];
                                           $ninzu[$i] += $q_count[$j];
                                           break;
                             case "【5】": $total[$i] += 5*$q_count[$j];
                                           $ninzu[$i] += $q_count[$j];
                                           break;
                             default:
			          $text_ans[] = "$q_content[$j]：$q_count[$j]";
                          }
                        }
                        if ($i <= 16) {
                           $ave[$i] = round($total[$i]/$ninzu[$i], 3);
                           $label[$i] = "問" . $i;
                        }
		}
		print ("<Table border=1><TR><TH>番号</TH><TH>合計</TH><TH>回答数</TH><TH>平均</TH><TH>質問ごとの評価</TH></TR>\n");
                print("<TR><TH>" . $label[1] . "</TH><TD align='center'>" . $total[1] . "</TD><TD align='center'>" . $ninzu[1] . "</TD><TD align='center'>" . $ave[1] . "</TD>");
                // レーダーチャート表示
                radar($label, $ave, "radar.png");
                print("<TD rowspan='16'><img src='radar.png'></TD></TR>");
              for ($i=2; $i<=16; $i++)
                           print("<TR><TH>" . $label[$i] . "</TH><TD align='center'>" . $total[$i] . "</TD><TD align='center'>" . $ninzu[$i] . "</TD><TD align='center'>" . $ave[$i] . "</TD></TR>");
             //   print("<TR><TH>問$i</TH><TD colspan='4'>$text_ans</TD></TR>");
		print("</TABLE>\n");

print ("<TABLE border=1 width=500>

<TR><TH></TH><TH>学生からの意見</TH></TR>");
for($i=0; $i<count($text_ans); $i++)
  print("<TR><TH>" . ($i+1) . "</TH><TD>" . $text_ans[$i] . "</TD></TR>");
if ($i<1) // 学生の意見が少ないない
  for($i=count($text_ans); $i<3; $i++)
      print("<TR><TH>" . ($i+1) . "</TH><TD></TD></TR>");
print("</TABLE>\n");
print ("<TABLE border=1 width=500>
<TR><TH>教員からのコメント</TH></TR>
<TR><TD><textarea name='comment' rows='5'>");
if (file_exists("$path/" . "comment.txt")) echo file_get_contents("$path/" . "comment.txt");
print("</textarea></TD></TR>
</TABLE>\n");
print ("<TABLE border=1 width=500>
<TR><TH>アンケート結果の分析</TH></TR>
<TR><TD><textarea name='analysis' rows='5'>");
if (file_exists("$path/" . "analysis.txt")) echo file_get_contents("$path/" . "analysis.txt");
print("</textarea></TD></TR>
</TABLE>\n");

print ("<TABLE border=1 width=500>
<TR><TH>今後の取り組み</TH></TR>
<TR><TD><textarea name='activity' rows='5'>");
if (file_exists("$path/" . "activity.txt")) echo file_get_contents("$path/" . "activity.txt");
print("</textarea></TD></TR>
</TABLE>\n");
$_SESSION['path'] = "$path/";
print('<INPUT type="submit" value="書込み" name="write">');

		//      if (isset($_POST[$path])) {  // 保存ボタンが押されたら
		//         $fp = fopen($path . "/tmp_counting.csv", "w");
		//         $header = "番号,氏名,回答日時,";
		//         $val = explode(",", $data[0]); // カンマで分割
		//         $j = count($val);
		//         for ($i=3; $i < $j-1; $i++)  // 質問番号を出力
		//            $header = $header . ($i-2) . ",";
		//         $header = $header . "\n";
		//         fputs($fp, mb_convert_encoding($header,"SJIS","SJIS,EUC-JP,auto"));
		//         for ($i = 0; $i<$n; $i++)
		//            fputs($fp, mb_convert_encoding($data[$i],"SJIS","SJIS,EUC-JP,auto"));
		//         fclose($fp);
		//         print('<DIV align="right">ダウンロード：<A href="' . $path . '/tmp_counting.csv">回答ファイル</A></DIV>' . "\n");
		//      }
	} else print_error("回答がありません");
}
// textarea を幅いっぱいにするスタイル
print('<style type="text/css">
textarea{
width:100%;
height:30%;
}
</style>');
print_header("アンケート");
if (!isset($_SESSION['id']) || ($_SESSION['id'] == "")) { // ログインしていない
	print("<SCRIPT language='JavaScript'>");
	print("window.alert('ログインしてください');");
	print("</SCRIPT>");
	print("<CENTER><A href='../main/index.php'>ログインページへ</A></CENTER>");
} else if ($_SESSION['admin']==0) { // 管理者でない
        print("<SCRIPT language='JavaScript'>");
	print("window.alert('あなたは管理者ではありません');");
	print("</SCRIPT>");
} else {
	print_headline("締切り後のアンケート集計");
	// 下のボタンをクリックすると，a?/tmp_counting.csv ファイルを作成します。<BR>
	// たとえば，a1/tmp_counting.csv は第１回アンケートの回答ファイルです。
	?>
<FORM method="POST" action="quest_result_graph_admin.php">
<CENTER><?php
print_title1("過去の回答集計");

if (isset($_POST['write'])) { // 書込みがクリックされたら
  file_put_contents($_SESSION['path'] . "comment.txt", $_POST['comment']);
  file_put_contents($_SESSION['path'] . "analysis.txt", $_POST['analysis']);
  file_put_contents($_SESSION['path'] . "activity.txt", $_POST['activity']);
}

$path = 0;
if (isset($_SESSION['path'])) unset($_SESSION['path']);
for ($i=1; $i<=20; $i++) {
	$x = "a" . $i;
	if (is_dir($x)) {
		if (isset($_POST[$x])) $path = $i;
		print('<INPUT type="submit" value="第' . $i . '回" name="' .$x. '">　');
	}
}
if ($path > 0) {
	print("<H4>第 $path 回</H4>\n");
	$mPath = "a" . $path . "/";
	save_allscore_counting("a". $path);
	print("<H4>アンケート</H4>");
	quest_preview($mPath, $mPath . "quest.csv");  // アンケート質問の表示
}
?></CENTER>
</FORM>
<?php
} print_copyright();
?>

</BODY>
</HTML>
