﻿<?php
session_start();
include("../param.inc");
include("quiz_preview.inc");
include("quiz_delete.inc");
include("quiz.ini");
/**
 *	改行を<BR>タグに置換
 *	@param $str 置換したい文字列
 *	@return 置換後の文字列
 */
function ret_replace2($str) {  // 改行を<BR>タグに置換
	$tmp = mb_convert_encoding($str, "UTF-8","auto");
	$str1 = str_replace("\r\n", "<BR>", $tmp);
	$tmp = str_replace("\n", "<BR>", $str1);
	return $tmp;
}

$mPath = "tmp/";           // 問題ファイルのパス
$mFile = $mPath . "quiz.csv";   // 小テストの一時ファイル名
$piccfile = $mPath . "piccount.txt"; // 図の管理番号ファイル
$tmppiccfile = $mPath . "tmpcount.txt"; // 仮の図の管理番号ファイル
print_header("小テスト");
if (!isset($_SESSION['id']) || ($_SESSION['id'] == "")) { // ログインしていない
	print("<SCRIPT language='JavaScript'>");
	print("window.alert('ログインしてください');");
	print("</SCRIPT>");
	print("<CENTER><A href='../main/index.php'>ログインページへ</A></CENTER>");
} else if ($_SESSION['admin']==0) { // 管理者でない
	print("<SCRIPT language='JavaScript'>");
	print("window.alert('あなたは管理者ではありません');");
	print("</SCRIPT>");
} else {
	print_headline("小テスト問題の追加");

	print('<FORM method="POST" action="quiz_make_sub.php" enctype="multipart/form-data">');
	print("<CENTER>"); // センタリング
	if (isset($_POST['mtype'])) $_SESSION['mtype'] = $_POST['mtype'];  // 問題形式
	$s = $_SESSION['mtype'];

	if ($s == 's' ) print_title1("選択問題");
	else if ($s == 'h') print_title1("複数選択問題");
	else if ($s == 'k') print_title1("記述問題");
	else                print_title1("二者択一問題");

	if (isset($_POST['clear'])) {  // クリアが押された
		$_POST['notes'] = NULL;  // 問題
		$_POST['kai'] = NULL;    // 解説
		//      $_POST['pic'] = NULL;    // 図
		if($s == 's') {   // 選択問題
			$_POST['A']=NULL;
			for($i=1; $i<=$quiz_MAX_ALT; $i++) {
				$tmp = "chose" . $i;
				$_POST[$tmp]=NULL;
			}
		} else if (($s == 'k') || ($s == 'k')) {  // 記述問題 か 二者択一問題
			$_POST['a']=NULL;
		} else if ($s == 'h') {  // 複数選択問題
			for($i=1; $i<=$quiz_MAX_ALT; $i++) {
				$tmp = "chose" . $i;
				$_POST[$tmp] = NULL;
				$_POST['A' . $i] = NULL;
			}
		}
	}
	print('<TABLE border=1>');
	print('<TR><TH>問題</TH><TD>');
	print('<TEXTAREA name="notes" rows="3" cols="100" wrap=virtual>');
	if (isset($_POST['notes'])) print(jcode_convert($_POST['notes']));
	print('</TEXTAREA></TD></TR>');
	if ($quiz_MODE >= 2)  // 図を使用する場合
	print('<TR><TH>図</TH><TD><input type="file" name="pict" size="100"></TD></TR>');
	print('<TR><TH>正解</TH><TD>');
	// 選択問題
	if($s == 's') {
		for($i=1; $i<=$quiz_MAX_ALT; $i++) {
			$tmp = "chose" . $i;
			print('<INPUT type="radio" name="A" value="' . $tmp . '"');
			if (isset($_POST['A'])) {
				if ($_POST['A'] == $tmp) print(" CHECKED");
			}
			print('>選択肢' . $i . '<INPUT type="text" name="' .$tmp .'" size="100" value="');
			if (isset($_POST[$tmp])) print(jcode_convert($_POST[$tmp]));
			print("\"><BR>\n");
		}
		// 記述問題
	} else if ($s == 'k') {
		print('<INPUT type="text" name="a" size="100" value="');
		if (isset($_POST['a'])) print(jcode_convert($_POST['a']));
		print("\"><BR>\n");
		// 二者択一問題
	} else if($s == 'n') {
		print('<INPUT type="radio" name="a" value="y"');
		if (isset($_POST['a'])) {
			if ($_POST['a'] == "y") print(" CHECKED");
		}
		print('>正しい<INPUT type="radio" name="a" value="n"');
		if (isset($_POST['a'])) {
			if ($_POST['a'] == "n") print(" CHECKED");
		}
		print(">間違い<BR>\n");
		// 複数選択問題
	} else if($s == 'h') {
		for($i=1; $i<=$quiz_MAX_ALT; $i++) {
			$tmp = "chose" . $i;
			print('<INPUT type="checkbox" name="A' . $i . '" value="' . $tmp . '"');
			if (isset($_POST['A' . $i])) {
				print(" CHECKED");
			}
			print('>選択肢' . $i . '<INPUT type="text" name="' .$tmp .'" size="100" value="');
			if (isset($_POST[$tmp])) print(jcode_convert($_POST[$tmp]));
			print("\"><BR>\n");
		}
	}

	print("</TD></TR>");
	print("<TR><TH>解説</TH><TD>");

	print('<TEXTAREA name="kai" rows="3" cols="100" wrap="soft">');
	if (isset($_POST['kai'])) print(jcode_convert($_POST['kai']));
	print("</TEXTAREA></TD></TR></TABLE>\n");

	if (isset($_POST['write'])) {
		if (jcode_convert($_POST['write']) == '確認') { // 入力が正しいかチェック
			$ok = 1;
			if ($_POST['notes'] == "" || $_POST['kai'] == "") {
				print_error("問題か解説が入力されていません"); $ok=0;
			} else {  // 問題形式ごとのエラーチェック
				// 選択問題
				if ($s == 's') {
					if (!isset($_POST['A'])) {
						print_error("正解が選択されていません"); $ok=0;
					} else {
						$i = 1; $ok = 0;
						while ($_POST['chose' . $i] != "") {
							if ($_POST['A'] == 'chose' . $i) $ok=$i;
							$i++;
							if ($i > $quiz_MAX_ALT) break;
						}
						for (; $i<=$quiz_MAX_ALT; $i++)  // 途中に空の選択肢があるかチェック
						if ($_POST['chose' . $i] != "") $ok = 0;
						if ($ok == 0) print_error("選択肢が不足しているか，空の選択肢があります");
					}
					// 記述問題
				} else if ($s == 'k') {
					if ($_POST['a'] == "") {
						print_error("正解が入力されていません"); $ok=0;
					}
					// 二者択一問題
				} else if ($s == 'n') {
					if (!isset($_POST['a'])) {
						print_error("正解が選択されていません"); $ok=0;
					}
					// 複数選択問題
				} else if ($s == 'h') {
					$i = 1; $ok = 0;
					while ($_POST['chose' . $i] != "") {
						if (isset($_POST['A' . $i])) $ok=$ok+pow(2,$i-1);
						$i++;
						if ($i > $quiz_MAX_ALT) break;
					}
					for (; $i<=$quiz_MAX_ALT; $i++)  // 途中に空の選択肢があるかチェック
					if ($_POST['chose' . $i] != "") $ok = 0;
					if ($ok == 0) print_error("正解が選択されていないか，選択肢が不足しています");
				}
			}
			if ($ok >  0) {
				$_SESSION['m'] = jcode_convert(ret_replace2($_POST['notes']));        // 問題
				$_SESSION['k'] = jcode_convert(ret_replace2($_POST['kai']));          // 解説
				if ($quiz_MODE >= 2) { // 図を使用する場合
					if (is_uploaded_file($_FILES['pict']['tmp_name'])) {
						if ($_FILES['pict']['tmp_name'] != "") {                   // 図
							if (file_exists($tmppiccfile)) {  // 仮の図番号管理
								$fp = fopen($tmppiccfile, "r+");
								$pic_no = fgets($fp, 10);
								fseek($fp, 0);
							} else {
								$fp = fopen($tmppiccfile, "w");
								$pic_no = 1;
							}
							$work = ($pic_no + 1) % 10 + 1;
							fputs($fp, "$work");
							fclose($fp);
							move_uploaded_file($_FILES['pict']['tmp_name'], $mPath . "tmp" . $pic_no . ".jpg");
							$_SESSION['picture'] = "tmp" . $pic_no . ".jpg";
						} else $_SESSION['picture'] = "";
					} else $_SESSION['picture'] = "";
				} else $_SESSION['picture'] = "";  // 図を使用しない場合
				for ($idx = 1; $idx <= $quiz_MAX_ALT; $idx++)
				$_SESSION["c$idx"]= "";                            // 選択肢idx
				if (($s == 's') || ($s == 'h')) { // 選択問題  か 複数選択問題
					$_SESSION['a'] = $ok;                 // 正解
					for ($idx = 1; $idx <= $quiz_MAX_ALT; $idx++)
					$_SESSION["c$idx"] = jcode_convert($_POST["chose$idx"]);   // 選択肢idx
				} else if (($s == 'k') || ($s == 'n')) {  // 記述問題  か  二者択一問題
					$_SESSION['a'] = jcode_convert($_POST['a']);         // 正解
				}
				// 入力された問題のプレビュー
				$_SESSION['m']= str_replace(",","，",$_SESSION['m']);  // 問題等の,を，に置換
				$_SESSION['k']= str_replace(",","，",$_SESSION['k']);
				$_SESSION['a']= str_replace(",","，",$_SESSION['a']);
				for ($idx = 1; $idx <= $quiz_MAX_ALT; $idx++)
				$_SESSION["c$idx"]= str_replace(",","，",$_SESSION["c$idx"]);
				$mon = $_SESSION['picture'] . ",$s," . $_SESSION['m'] . "," . $_SESSION['k'] . "," . $_SESSION['a'];
				for ($idx = 1; $idx <= $quiz_MAX_ALT; $idx++)
				$mon = $mon . "," . $_SESSION["c$idx"];
				print_title2("問題のプレビュー");
				print("<TABLE border=1>");
				quiz_preview_1($mPath, $mon);
				print("</table>\n");
				print('<INPUT type="submit" name="write" value="保存">');
				print('<INPUT type="submit" name="rewrite" value="修正">');
			} else print('<INPUT type="submit" name="write" value="確認">');
		} else {   // 保存
			if ($_SESSION['m'] != "") { // 2重保存防止
				$_SESSION['m']= str_replace(",","，",$_SESSION['m']);  // 問題等の,を，に置換
				$_SESSION['k']= str_replace(",","，",$_SESSION['k']);
				$_SESSION['a']= str_replace(",","，",$_SESSION['a']);
				for ($idx = 1; $idx <= $quiz_MAX_ALT; $idx++)
				$_SESSION["c$idx"]= str_replace(",","，",$_SESSION["c$idx"]);
				// 図の処理
				if ($_SESSION['picture'] != "") { // 図番号のセット
					if (file_exists($piccfile)) {
						$fp = fopen($piccfile, "r+");
						$pic_no = fgets($fp, 10);
						fseek($fp, 0);
					} else {
						$fp = fopen($piccfile, "w");
						$pic_no = 1;
					}
					$work = $pic_no + 1;
					fputs($fp, "$work");
					fclose($fp);
					rename($mPath . $_SESSION['picture'], $mPath . $pic_no . ".jpg");
					$_SESSION['picture'] = $pic_no . ".jpg";
				}
				$mon = $_SESSION['picture'] . ",$s," . $_SESSION['m'] . "," . $_SESSION['k'] . "," . $_SESSION['a'];
				for ($idx = 1; $idx <= $quiz_MAX_ALT; $idx++)
				$mon = $mon . "," . $_SESSION["c$idx"];
				if (file_exists($mFile)) $file = fopen($mFile, "a");
				else                     $file = fopen($mFile, "w");
				fwrite($file, $mon . "\n");
				fclose($file);
				$_SESSION['m']="";  // 問題等の削除
				$_SESSION['k']="";
				$_SESSION['a']="";
				$_SESSION['picture'] = "";
				for ($idx = 1; $idx <= $quiz_MAX_ALT; $idx++) $_SESSION["c$idx"]="";
			}
			print('<INPUT type="submit" name="write" value="確認">');
		}
	} else print('<INPUT type="submit" name="write" value="確認">');

	print('<INPUT type="submit" name="clear" value="クリア">');
	if ($quiz_MODE == 3) // 数式を使用する場合
	print('　<A href="../mimetex-edit.php" target="medit">数式を入力するには</A>');
	print('　<A href="quiz_make.php">問題形式を変更する</A><BR>');

	print_title2("登録されている問題");
	if (isset($_POST['publish'])) {
		if (is_dir("doc")) print_error("すでに公開されている小テストがあります。締切が過ぎているのなら移動してください");
		else {  // 公開ディレクトリ doc に移動
			rename("tmp", "doc");  // ディレクト名の変更
			//         exec("mv tmp doc");
			umask(0);
			mkdir("tmp", 0707);
		}
	}
	$mBuf = NULL;
	$mBuf = quiz_read($mFile);
	if (count($mBuf) > 0) print('<DIV align="right"><INPUT type="submit" name="publish" value="公開する"></DIV>');
	quiz_view($mPath, $mBuf);
	?>
</CENTER>
</FORM>
	<?php
} print_copyright();
?>
</BODY>
</HTML>
