<?php
$mPath ="tmp/";           // 問題ファイルのパス
$mFile = $mPath . "quiz.csv";  // 問題ファイル名

/**
 *	ファイルから問題等を配列に読み込む
 *	@param $file 問題ファイル名
 */
function quiz_read($file) {
	if (!file_exists($file))  // 現在，問題がありません
	return array();
	else {
		$buf = file($file);  // ファイルから配列に読み込む
		return $buf;
	}
}

/**
 *	配列内の問題表示(削除ボタン付き)
 *	@param $mPath 問題ファイル保存フォルダ
 *	@param $buf   追加用問題内容の格納配列
 */
function quiz_view($mPath, $buf) {
	global  $mFile;   // 問題ファイル名

	$n = count($buf);
	for($m = 0; $m < $n; $m++) {  // 削除ボタンの処理
		if (isset($_POST["del" . $m])) { // 削除ボタンが押されたら
			$file = fopen($mFile, "w");
			for ($i=0; $i < $n; $i++)
			if ($i != $m) {
				fputs($file, $buf[$i]);
			} else {  // 図があれば図のファイルを削除
				$pic = explode(",", $buf[$i]);
				if (($pic[1] != "") && (file_exists($mPath . $pic[1]))) unlink($mPath . $pic[1]);
			}
			fclose($file);
			print_message("1問削除しました");
		}
	}
	$buf = array();
	$buf = quiz_read($mFile);
	$n = count($buf);
	if ($n > 0) {       // 小テスト問題があれば
		print("<table border=1>");
		for($m = 0; $m < $n; $m++) {
			$data = array();
			$tmp = chop($buf[$m]);     // 行末の改行文字を取り除く
			$nop = $m+1;        // 問題番号
			print('<TR><TH><INPUT type="SUBMIT" name="del' . $m . '" value="削除"></TH>' . "\n");
			print("<TH bgcolor='BLUE'><FONT color='WHITE'>No: $nop </FONT></TH></TR>");
			quiz_preview_1($mPath, $tmp);
		}
		print("</TABLE>\n");
	}  else print_error("現在登録されている問題はありません");
}
?>
