<?php  // ランキング表示（学習者用）
session_start();
include("../param.inc");
include_once("quiz_preview.inc");

/**
 *	得点順にソートする関数
 *	@param $val1 回答データ1
 *	@param $val2 回答データ2
 *	@return 比較結果（1,0,-1)
 */
function sort_by_ranking($val1, $val2) {
	$v1 = explode(",", $val1);
	$v2 = explode(",", $val2);
	if ($v1[2] > $v2[2]) return -1;   // 得点
	else if ($v1[2] == $v2[2]) {
		if ($v1[4] > $v2[4]) return 1;  // 回答時間
		else if ($v1[4] == $v2[4]) return 0;
		else return -1;
	} else return 1;
}

/**
 *	全員の成績を表示
 *	@param $path 成績保存フォルダ
 */
function show_allscore_ranking($path) {
	$n = count($_SESSION['no']);   //  ユーザ数
	$data = NULL;
//// 2015.02.06s
	$mondai = file("$path/quiz.csv");  // 配列 $mondaiに読み込み
	$n_of_q = count($mondai);  // 問題数
//// 2015.02.06e
	for ($i=0; $i<$n; $i++) {
		$scorefile = "$path/" . $_SESSION['uid'][$i];
		if (file_exists($scorefile)) {
			$fp = fopen($scorefile, "r");
			$ans = 0;
			$que = 0;
			$time = 0;
			$answer = array(); // 回答を保存
			while ($tmp = fgets($fp, 4096)){  // 成績を取り込む
			$val = explode(",", $tmp); // カンマで分割
			$no = $val[0];
			$name = $val[1];
			$ans += $val[2];
			$que += $val[3];
			$time += $val[5];
			for($a = 6; $a < count($val)-1; $a = $a+3)
			  $answer[$val[$a]] = array($val[$a+1], $val[$a+2]);
			}
			$tmp = "$no,$name,$ans,$que,$time";
			ksort($answer); // 問題番号（キー）順に並び替え
//// 2015.02.06s
			$n_of_i = 1; // 問題番号（作業用）
			foreach($answer as $key => $value) {// 回答を連結
                           while($n_of_i < (int)$key) { // 未回答問題
                              $tmp = "$tmp,$n_of_i,,";
                              $n_of_i++;
                           }
                           $tmp = "$tmp,$key," . $value[0] . "," . $value[1];
                           $n_of_i++;
                        }
                        // 残りの未回答問題の処理
                        while ($n_of_i <= $n_of_q) {
                           $tmp = "$tmp,$n_of_i,,";
                           $n_of_i++;
                        }
//// 2015.02.06e
			$data[] = $tmp;
			fclose($fp);
		}
	}
	$n = count($data);
	if ($n > 0) {  // 成績があれば
		// $data を得点順にソート
		usort($data, "sort_by_ranking");

		// 成績表を表示 
		print("<TABLE border=1><TR><TH>順位</TH><TH>氏名</TH><TH>得点</TH><TH>問題数</TH><TH>時間(秒)</TH>\n");
		for ($i=1; $i <= $n_of_q; $i++)  // 問題番号を出力
		print("<TH>" . $i . "</TH>");
		print("</TR>\n");
		for ($i = 0,$ranking=1; $i < $n; $i++,$ranking++) {
			$val = explode(",", $data[$i]); // カンマで分割
                        // ヘッダ情報
			print("<TR><TD align='center'>$ranking</TD><TD>");
			if ($val[1] == $_SESSION['user'])     // 自分の成績なら名前を表示
			print("<FONT color='blue'>$val[1]</FONT>");
			else print("********");
			print("</TD><TD align='center'>$val[2]</TD><TD align='center'>$val[3]</TD><TD align='right'>$val[4]</TD>\n");
			// 回答情報
                        $j = $n_of_q*3 + 5; // 学生の回答数
			for ($k = 5; $k< $j; $k=$k+3) {
				print("<TD align='center'>" . $val[$k] . "<BR>" . $val[$k+1]);  //  問題番号，生徒の解答
				if ($val[$k+2] == "○") // 正解
				print("<BR><FONT color='BLUE'>○</FONT></TD>");
				else if ($val[$k+2] == "×")  // 間違い
				print("<BR><FONT color='RED'>×</FONT></TD>");
				else print("<BR></TD>");
			}
			print("</TR>\n");
		}
		print("</TABLE>\n");
	} else print_error("成績がありません");
}

print_header("小テスト");
if (!isset($_SESSION['id']) || ($_SESSION['id'] == "")) { // ログインしていない
	print("<SCRIPT language='JavaScript'>");
	print("window.alert('ログインしてください');");
	print("</SCRIPT>");
	print("<CENTER><A href='../main/index.php'>ログインページへ</A></CENTER>");
} else {
	print_headline("締切り後の成績（得点順）表示");
	?>
成績を得点の高い順に表示します。<BR>
複数回回答しても，最初の成績だけをランキング表示しています。
<BR>
得点が同じ場合は，解答時間の少ない方が上位に表示されます。

<FORM method="POST" action="quiz_ranking.php">
<CENTER><?php
print_title1("過去の成績（得点順）");

$path = 0;
for ($i=1; $i<=20; $i++) {
	$x = "q" . $i;
	if (is_dir($x)) {
		if (isset($_POST[$x])) $path = $i;
		print('<INPUT type="submit" value="第' . $i . '回" name="' .$x. '">　');
	}
}
if ($path > 0) {
	print("<H4>第 $path 回</H4>\n");
        $mPath = "q". $path;
	show_allscore_ranking($mPath);
	quiz_preview($mPath, $mPath . "/quiz.csv");  // 問題、解答、解説の表示
}
?></CENTER>
</FORM>
<?php
} print_copyright();
?>

</BODY>
</HTML>
