<?php
session_start();
include("../param.inc");
$pDir = "doc/memo/";   // 課題説明ディレクトリ
$pFile = $pDir . "problem.txt";   // 課題説明ファイル
print_header("レポート");
if (!isset($_SESSION['id']) || ($_SESSION['id'] == "")) { // ログインしていない
	print("<SCRIPT language='JavaScript'>");
	print("window.alert('ログインしてください');");
	print("</SCRIPT>");
	print("<CENTER><A href='../main/index.php'>ログインページへ</A></CENTER>");
} else if ($_SESSION['admin']==0) { // 管理者でない
	print("<SCRIPT language='JavaScript'>");
	print("window.alert('あなたは管理者ではありません');");
	print("</SCRIPT>");
} else {
	print_headline("レポートの課題編集");

	print('<FORM method="POST" action="problem_edit.php">');
	print("<CENTER>"); // センタリング

	$_SESSION['Ptext']="";
	$t = getdate();
	$_SESSION['Pmonth']=$t['mon'];
	$_SESSION['Pday'] = $t['mday'];

	if (isset($_POST['delete'])) {// 削除ボタンが押されたら削除
		if (file_exists($pFile)) unlink($pFile);
		$_SESSION['Ptext'] = "";
	} else {
		if (file_exists($pFile)) {      // 課題説明ファイルがあれば
			$file = fopen($pFile, "r");
			$days = NULL;
			$days = fgetcsv($file, 255);
			$_SESSION['Ptext'] = jcode_convert(fread($file, filesize($pFile)));  // 説明文
			fclose($file);
			$_SESSION['Pmonth'] = $days[0];           // 締切月
			$_SESSION['Pday'] = $days[1];             // 締切日
		}
		if (!isset($_POST['reset'])) {  // リセットが押されてなければ
			if (isset($_POST['month'])) $_SESSION['Pmonth'] = $_POST['month'];
			if (isset($_POST['day'])) $_SESSION['Pday'] = $_POST['day'];
			if (isset($_POST['problem'])) $_SESSION['Ptext'] = jcode_convert($_POST['problem']);
		}
	}
	$i = 1;
	while(file_exists("r" . $i)) $i++;
	print_title1("第 $i 回レポート");

	print("<H4>課題説明</H4>");
	print('<H5>提出締切 ');
	print('<SELECT name="month">');
	for ($i = 1; $i < 13; $i++) {
		if ($i == $_SESSION['Pmonth']) print('<OPTION value="' . $i . '" selected>' . $i);
		else print('<OPTION value="' . $i . '">' . $i);
	}
	print('</SELECT> 月 ');
	print('<SELECT name="day">');
	for ($i = 1; $i < 32; $i++) {
		if ($i == $_SESSION['Pday']) print('<OPTION value="' . $i . '" selected>' . $i);
		else print('<OPTION value="' . $i . '">' . $i);
	}
	print('</SELECT> 日</H5>');
	print('<TEXTAREA name="problem" rows="10" cols="100" wrap=virtual>');
	print($_SESSION['Ptext']);
	print('</TEXTAREA><BR>');

	if (isset($_POST['write'])) {
		if ((jcode_convert($_POST['write']) == '確認') |
		(jcode_convert($_POST['write']) == '修正'))   { // 入力が正しいかチェック
			$ok = 1;
			if ($_SESSION['Ptext'] == "") {
				print_error("課題説明が入力されていません"); $ok=0;
			}
			if ($ok >  0) {
				$_SESSION['month'] = $_POST['month'];  // 締切月
				$_SESSION['day'] = $_POST['day'];      // 締切日
				$_SESSION['Ptext'] = jcode_convert($_POST['problem']);            // 説明文
				print('<INPUT type="submit" name="write" value="保存">');
				print('<INPUT type="submit" name="write" value="修正">');
			} else print('<INPUT type="submit" name="write" value="確認">');
		} else {   // 保存
			$exp = $_SESSION['Ptext'];
			if (!is_dir($pDir)) {   // 課題説明ディレクトリが存在しないときは
				umask(0);
				mkdir($pDir, 0707);  // 作成
			}
			$file = fopen($pFile, "w");
			fwrite($file, $_SESSION['month'] . "," . $_SESSION['day'] . "\n");
			fwrite($file, $exp . "\n");
			fclose($file);
			print('<INPUT type="submit" name="write" value="確認">');
		}
	} else print('<INPUT type="submit" name="write" value="確認">');
	print('<INPUT type="submit" name="delete" value="削除">');
	print('<INPUT type="submit" name="reset" value="リセット"><BR>');
	// 入力された課題説明のプレビュー
	if (isset($_SESSION['Ptext']) && ($_SESSION['Ptext'] != "")) {
		print_title2("課題説明のプレビュー");
		print('<H4>提出締切 ' . $_SESSION['Pmonth'] . '月 ' . $_SESSION['Pday'] . '日</H4>' . "\n");
		print(ret_replace($_SESSION['Ptext']) . "\n");
	}
	?>
</CENTER>
</FORM>
	<?php
} print_copyright();
?>
</BODY>
</HTML>
