﻿<?php
//  レポート管理システム  Ver. 0.1
//
//  管理者用
//      現在のレポート確認・削除モード変更 ./doc
//      過去のレポート確認 ./r1 ～ ./r20  第1回から第20回まで
session_start();
include("../param.inc");
include("repo.inc");

/**
 *	レポートファイル一覧のファイル保存（管理者用）
 *	@param $curPath   レポートフォルダ
 *	@param $no_id     出席番号の配列
 *	@param $uname_id  氏名の配列
 *	@param $file      保存ファイル名
 *	@return           なし
 */
function listing_admin($curPath, $no_id, $uname_id, $file) {
	global $report2_COMMENT_ON, $IDlength;

	$filelist = NULL;
	$d=dir($curPath);
	while($entry=$d->read()){
		if ($entry!="." && $entry!=".."){
///			$id = mb_substr($entry, 0, $IDlength); // strlen($_SESSION['id'])); user id
////////////////////  最初の'-'より前の文字列をIDと判断する
                        $id = getIDfromFname($entry);
////////////////////
			$strTmp= $curPath . "/" .$entry;
			if (!is_dir($strTmp) && ($entry != "index.html")) {    // ディレクトリかつindex.htmlでなければ
				// id から 出席番号, 氏名を調べ
				// 出席番号，      氏名，      ファイルパス，   ファイル名，ファイル更新日時  削除ボタン
				$filelist[] = $no_id[$id] . "," . $uname_id[$id] . "," . $entry . "," . $entry . "," . filesize($strTmp) . "," . filemtime($strTmp);
			}
		}
	}
	$d->close();
	$n = count($filelist);  // ファイル数
	if ($n > 0) {
		usort($filelist, "sort_by_no_report");  /* 出席番号,ファイル名順にソート */
		fwrite($file,'<TABLE border="1">');
		fwrite($file,"<TR>");
		fwrite($file,"<TH>No</TH><TH>氏   名</TH><TH>ファイル名</TH>");
		fwrite($file,"<TH>サイズ(Byte)</TH><TH>最終更新日時</TH>");
/// old comment		if ($report2_COMMENT_ON== 1) fwrite($file,"<TH>コメント</TH>");
		fwrite($file,"</TR>");
		for ($i = 0; $i < $n; $i++) {
			$val = explode(",", $filelist[$i]); /* カンマで分割 */
			fwrite($file,"<TR>");
			fwrite($file,"<TD nowrap> $val[0] </TD>");
			fwrite($file,"<TD nowrap> $val[1] </TD>");
			fwrite($file,"<TD nowrap><A href='" . $val[2] . "'>" . $val[3] . "</A></TD>");
			fwrite($file,'<TD nowrap align="right">'. number_format($val[4]) . "</TD>");
			fwrite($file,"<TD nowrap>". date("Y/m/d H:i",$val[5]) . "</TD>");
/*** old comment			if ($report2_COMMENT_ON == 1) {
				//            $result = exec("head -1 $val[2]");
				$rp = fopen($val[2], "r");  // ファイルの先頭行を読み込む
				$result = fgets($rp);
				fclose($rp);
				fwrite($file,"<TD>" . jcode_convert($result) . "</TD>");
			}
old comment ***/
			fwrite($file,"</TR>\n");
		}
		fwrite($file,"</TABLE>\n");
	}
	//  課題説明ファイルがあれば出力
	$pF = $curPath . "/memo/problem.txt";
	if (file_exists($pF)) {      // 課題説明ファイルがあれば
		$f = fopen($pF, "r");
		$days = NULL;
		$days = fgetcsv($f, 255);
		$text = jcode_convert(fread($f, filesize($pF)));  // 説明文
		fclose($f);
		fwrite($file, "<H4>提出締切 $days[0] 月 $days[1] 日</H4>\n");
		fwrite($file, ret_replace($text) . "<HR>\n");
	}
}
?>
<HTML>
<HEAD>
<META http-equiv="Content-Type" content="text/html; charset=UTF-8">
<TITLE>レポート</TITLE>
</HEAD>
<BODY>

<?php
if (!isset($_SESSION['id']) || ($_SESSION['id'] == "")) { // ログインしていない
	print("<SCRIPT language='JavaScript'>");
	print("window.alert('ログインしてください');");
	print("</SCRIPT>");
	print("<CENTER><A href='../main/index.php'>ログインページへ</A></CENTER>");
} else if ($_SESSION['admin']==0) { // 管理者でない
	print("<SCRIPT language='JavaScript'>");
	print("window.alert('あなたは管理者ではありません');");
	print("</SCRIPT>");
} else {
	print_headline("レポート閲覧用インデックスファイルの作成");
	?>
下のボタンをクリックすると，r?/index.html ファイルを作成します。
<BR>
たとえば，r1/index.html は第１回レポートのインデックスファイルです。
<BR>
<HR>
<FORM method="POST" action="webrepo_listup.php">
<CENTER><?php
print_title1("過去のレポート");

$path = 0;
for ($i=1; $i<=20; $i++) {
	$x = "r" . $i;
	if (is_dir($x)) {
		if (isset($_POST[$x])) $path = $i;
		print('<INPUT type="submit" value="第' . $i . '回" name="' . $x . '">　');
	}
}
if ($path > 0) {
	$file = fopen("./r" . $path . "/index.html", "w");
	fwrite($file,'<HTML> <HEAD><META http-equiv="Content-Type" content="text/html; charset=UTF-8">' . "\n");
	fwrite($file, "<TITLE>レポート管理ページ</TITLE> </HEAD> <BODY>\n");
	fwrite($file, "<H3>" . $Title . "<BR>第 $path 回レポート</H3><HR>\n");
	listing_admin("./r" . $path, $_SESSION['no_id'],$_SESSION['uname_id'], $file);
	fwrite($file, "</BODY></HTML>");
	fclose($file);
	print ('<A href="./r' . $path . '/index.html">確認して下さい</A>' . "\n");
}
print("</CENTER>");
print("</FORM>");
} print_copyright();
?>

</BODY>
</HTML>
