﻿<?php
//  レポート管理システム  Ver. 0.1
//
//  管理者用
//      現在のレポート確認・削除モード変更 ./doc
//      過去のレポート確認 ./r1 ～ ./r20  第1回から第20回まで
//      課題説明ファイル作成・編集  ./doc/memo/problem.txt

include("init.php");

$pDir = "doc/memo/";   // 課題説明ディレクトリ
//  $pFile = $pDir . "problem.txt";   // 課題説明ファイル

//function print_problem($File) {
////  課題説明ファイルがあれば出力
//   if (file_exists($File)) {      // 課題説明ファイルがあれば
//      $file = fopen($File, "r");
//      $days = NULL;
//      $days = fgetcsv($file, 255);
//      $text = jcode_convert(fread($file, filesize($File)));  // 説明文
//      fclose($file);
//      print("<H4>提出締切 $days[0] 月 $days[1] 日</H4>\n");
//      print(ret_replace($text));
//   }
//}

/**
 *	ファイル名からIDを抽出
 *	@param $fname  ファイル名
 *	@return ID
 */
function getIDfromFname($fname) //  最初の'-'より前の文字列をIDと判断する
{
    $id = mb_substr($fname, 0, strpos($fname,'-'));
    return $id;
}

/**
 *	レポートファイル一覧の表示
 *	@param $curPath  レポートフォルダ
 *	@param $rm_on    削除ボタン 1:表示 0:非表示
 *	@param $no_id    出席番号の配列
 *	@param $uname_id 氏名の配列
 *	@param $umode    ユーザモード 1:管理者 0:学生
 *	@return ファイル数
 */
function listing_report($curPath, $rm_on, $no_id, $uname_id, $umode)
{
	global $report_plus_COMMENT_ON, $IDlength, $report_plus_LANGUAGE;

	$filelist = array();
	$d=dir($curPath);
	while($entry=$d->read()){
		if ($entry!="." && $entry!=".."){
///                     $id = mb_substr($entry, 0, $IDlength); // strlen($_SESSION['id']));   user id
////////////////////  最初の'-'より前の文字列をIDと判断する
                        $id = getIDfromFname($entry);
////////////////////
			$strTmp=$curPath."/".$entry;
			$aryInfo=pathinfo($strTmp);
			$btName = str_replace(".","-",$entry);
			if (isset($_POST[$btName])) {  // 削除ボタンが押された
				unlink($strTmp);
				print_message("[ $entry ] 削除しました");
			} else {
				if (!is_dir($strTmp) && ($entry != "index.html") && ($entry != ".htaccess") && ($entry != "error.csv")) {    // ディレクトリかindex.htmlでなければ
					if (($umode == 1) || ($id == $_SESSION['id'])) { // 管理者か自分のファイルなら
						// id から 出席番号, 氏名を調べ
						// 出席番号，      氏名，      ファイルパス，   ファイル名，ファイル更新日時  削除ボタン  id(学籍番号)
						$filelist[] = $no_id[$id] . "," . $uname_id[$id] . "," . $strTmp . "," . $entry . "," . filesize($strTmp) . "," . filemtime($strTmp) . "," . $btName . "," . $id;
					}
				}
			}
		}
	}
	$d->close();

	$n = count($filelist);  // ファイル数
	if ($n > 0) {
////  H25.05.09 エラーコメントの表示
                if (file_exists($curPath . "/error.csv")) {  // エラーコメントフィルが存在するとき
                   $error_list = array();
                   $fp = fopen($curPath . "/error.csv","r");
                   while ($data = fgets($fp)) {
                      $f = explode(",",$data);
                      $error_list[$f[0]] = $f[1];
                   }
                   fclose($fp);
                }
////
		usort($filelist, "sort_by_no_report");  /* 出席番号,ファイル名順にソート */
        $tmp_no = -1;
	for ($i = 0; $i < $n; $i++) { //個人ファイル数
		$val1 = explode(",", $filelist[$i]); /* カンマで分割 */
		if($val1[0] != $tmp_no) {
                    $file_count[$val1[0]] = 1;
		    $tmp_no = $val1[0];
                }
		else if($val1[0] == $tmp_no) $file_count[$val1[0]] += 1;
	}
	if ($curPath != "./doc" && $report_plus_COMMENT_ON == 1) // 締め切り後でコメントオンなら
                print("ファイル名に<font color='red'>*</font>が付いたものは，間違いがあります。確認して下さい。");
		print('<TABLE border="1">');
		print("<TR>");
		print("<TH>No</TH><TH>氏   名</TH><TH colspan=" . ($rm_on + 1) . ">ファイル名</TH>");
		print("<TH>サイズ(Byte)</TH><TH>最終更新日時</TH><TH>ファイル数</TH>");
// old comment		if ($report_plus_COMMENT_ON== 1) print("<TH>コメント</TH>");
		print("</TR>");
                $tmp_no = -1;
		
		for ($i = 0; $i < $n; $i++) {
			$val = explode(",", $filelist[$i]); /* カンマで分割 */
			print("<TR>");
			if ($val[0] != $tmp_no) {
				print("<TD nowrap rowspan=". $file_count[$val[0]] ."> $val[0] </TD>");
			}
///// 2011.2.8 source code highlight
			if ($report_plus_LANGUAGE == "") { // 言語設定がなければ通常表示
			               if ($val[0] != $tmp_no) print("<TD nowrap rowspan=". $file_count[$val[0]] ."> $val[1] </TD>");
                           print("<TD nowrap><A href='" . $val[2] . "'>" . $val[3] . "</A></TD>");
                        } else {               // ソースコードをハイライティング
                           if ($val[0] != $tmp_no)
			   print("<TD nowrap rowspan=". $file_count[$val[0]] ."><A href='sourceview_all.php?uid=" . $val[7] . "&path=" . urlencode($curPath) . "' target='_blank'>" . $val[1] . "</A></TD>");
                           print("<TD nowrap><A href='sourceview.php?file=" . urlencode($val[2]) . "' onClick=\"window.open(this.href, '_blank'); return false;\">$val[3]</A>");
/////      エラーコメントがあれば
                        if (isset($error_list[$val[3]]))
                           print(" <font color='red'>*</font>");
/////
                        print("</TD>");
/////
                        }
			if ($rm_on == 1)
			print('<TD><INPUT type="submit" value="削除" name="' . $val[6] . '"></TD>');
			print('<TD nowrap align="right">'. number_format($val[4]) . "</TD>");
			print("<TD nowrap>". date("Y/m/d H:i",$val[5]) . "</TD>");
			if ($val[0] != $tmp_no) print('<TD nowrap align="right" rowspan='. $file_count[$val[0]] .'>'. $file_count[$val[0]] .'</TD>');
/* old comment			if ($report_plus_COMMENT_ON == 1) {
				//            if (filetype($val[2]) == "char") {  // テキストファイルなら
				//            $result = exec("head -1 $val[2]");
				$rp = fopen($val[2], "r");  // ファイルの先頭行を読み込む
				$result = fgets($rp);
				fclose($rp);
				print("<TD>" . jcode_convert($result) . "</TD>");
				//            } else
				//              print("<TD>*****</TD>");
			}
old comment ***/
			print("</TR>\n");
			$tmp_no = $val[0];
		}
		print("</TABLE>\n");
	} else print_error("提出されたレポートはありません");
	//  課題説明の出力
	print_problem($curPath . "/memo/problem.txt");
	return $n;
}
/**
 *	ディレクトリ内のファイル数(.htaccessを除く)を数える
 *	@param $path  ディレクトリ
 *	@return count ファイル数
 */
function count_file($path)
{
   $files = scandir($path);
   $count = 0;
   foreach ($files as $file){
     if (($file != ".htaccess") && (is_file($path . "/" . $file))){
        $count++;
     }
   }
   return($count);
}
?>
