﻿<?php
include("../param.inc");
include("repo.inc");
// #ステップ１ - ライブラリインクルード
if (file_exists($geshiPATH))
   include($geshiPATH);
else
   $report_plus_LANGUAGE = "txt";
////  H25.05.09 エラーコメントの表示
if (file_exists(dirname($_GET['file']) . "/error.csv")) {  // エラーコメントフィルが存在するとき
   $error_list = array();
   $fp = fopen(dirname($_GET['file']) . "/error.csv","r");
   while ($data = fgets($fp)) {
      $f = explode(",",$data);
      $error_list[$f[0]] = htmlspecialchars($f[1]);
   }
   fclose($fp);
}
////
?>
<html lang="ja">
<head>
<meta http-equiv="Content-Type" Content="text/html;charset=UTF-8">
<title>ソースの表示</title>
</head>
<body>

<?php
$tmp = file_get_contents($_GET['file']);
$source = jcode_convert($tmp);
if ($report_plus_LANGUAGE == "txt") { // 言語設定がプレーンテキストなら
   print "<pre>\n";
   print $source;
   print "</pre>\n";
} else {
   //// H25.05.09 エラーコメントの表示
   $f = basename($_GET['file']);
   if (isset($error_list[$f])) { // エラーコメントがあるとき
      print "<font color='red'>間違い情報</font><BR>";
      print $error_list[$f];
      print "<HR>";
   }
   ////
   // #ステップ２ - GeSHiインスタンス生成
   // $report_plus_LANGUAGE = "C";
   $geshi = new GeSHi($source, $report_plus_LANGUAGE);
   // 行番号表示
   $geshi->enable_line_numbers(GESHI_NORMAL_LINE_NUMBERS);
   // 複数行コメントをイタリックにしないようにした
   $geshi->set_comments_style('MULTI', 'display: hidden;');
   // 1行コメントをイタリックにしないようにした
   //$geshi->set_comments_style(1, 'display: hidden;');
   // #ステップ３ - 変換実行
   $result = $geshi->parse_code();
   echo $result;
}
?>
</body>
</html>
