<?php
$dFile = "daily.csv";


function sort_by_date($val1, $val2) {  // 日付順にソート
	$v1 = explode(",", $val1);
	$v2 = explode(",", $val2);
	if ($v1[0] < 4) $v1[0] = $v1[0]+12;
	if ($v2[0] < 4) $v2[0] = $v2[0]+12;
	if ($v1[0] > $v2[0]) return 1;
	else if ($v1[0] == $v2[0]) {
		if ($v1[1] > $v2[1]) return 1;
		else if ($v1[1] == $v2[1]) return 0;
		else return -1;
	} else return -1;
}

// 講義日誌の表示

function daily_view($mFile, $rm_on) {
	$nop = 0;

	if (!file_exists($mFile)) print_error("現在，日誌がありません");
	else {
		$m = NULL;  // 削除されたかも知れないので読み直し
		$m = file($mFile);
		$n = count($m);
		if ($n == 0) print_error("現在、日誌がありません");
		else {
			usort($m, "sort_by_date"); // 日付順にソート
			print("<TABLE border=1>");
			print("<TR><TH>No.</TH><TH>月</TH><TH>日</TH><TH width='500'>内　　容</TH><TH width=50>備考</TH></TR>");
			for ($i = 0; $i < $n; $i++) {
				$tmp = chop($m[$i]);  // 行末の改行文字を取り除く
				$data = NULL;
				$data = explode(",", $tmp);
				$nop = $nop+1;        // 番号
				print("<TR><TH>$nop");
				if ($rm_on == 1) // 削除ボタン表示
				print('<INPUT type="submit" value="削除" name="del' . ($nop - 1) . '">');
				print("</TH><TD>$data[0]</TD><TD>$data[1]</TD><TD width='500'>$data[2]</TD><TD>$data[3]</TD></TR>");
			}
			print("</TABLE>\n");
		}
		return $nop;  // 講義数を返す
	}
}
?>
