<?php
$mPath ="tmp/";           // 質問ファイルのパス
$mFile = $mPath . "quest.csv";  // 質問ファイル名

function quest_read($file) {   //  ファイルから質問等を配列に読み込む
	if (!file_exists($file))  // 現在，質問がありません
	return NULL;
	else {
		$buf = file($file);  // ファイルから配列に読み込む
		return $buf;
	}
}

function quest_view($mPath, $buf) {  // 配列内の質問表示(削除ボタン付き)
	global  $mFile;   // 質問ファイル名

	$n = count($buf);
	for($m = 0; $m < $n; $m++) {  // 削除ボタンの処理
		if (isset($_POST["del" . $m])) { // 削除ボタンが押されたら
			$file = fopen($mFile, "w");
			for ($i=0; $i < $n; $i++)
			if ($i != $m) {
				fputs($file, $buf[$i]);
			} else {  // 図があれば図のファイルを削除
				$pic = explode(",", $buf[$i]);
				if (($pic[0] != "") && (file_exists($mPath . $pic[0]))) unlink($mPath . $pic[0]);
			}
			fclose($file);
			print_message("1問削除しました");
		}
	}
	$buf = NULL;
	$buf = quest_read($mFile);
	$n = count($buf);
	if ($n > 0) {        // アンケート質問があれば
		print("<TABLE border=1>");
		for($m = 0; $m < $n; $m++) {
			$data = NULL;
			$tmp = chop($buf[$m]);     // 行末の改行文字を取り除く
			$nop = $m+1;        // 質問番号
			print('<TR><TH><INPUT type="SUBMIT" name="del' . $m . '" value="削除"></TH>');
			print('<TH bgcolor="BLUE"><FONT color="WHITE">No:' . $nop . "</FONT></TH></TR>\n");
			quest_preview_1($mPath, $tmp);
		}
		print("</TABLE>\n");
	} else print_error("現在登録されている質問はありません");
}
?>
