<?php
session_start();
include("../param.inc");
include("quiz_preview.inc");

function print_score($scorefile) {  // 成績の表示
	if (!file_exists($scorefile))
	print_error("成績ファイルがありません");
	else {
		$fp = fopen($scorefile, "r");
		$data = NULL;
		while ($data[] = fgets($fp, 4096));  // 成績を取り込む
		fclose($fp);
		$n = count($data);
		if ($n > 1) {
			print("<TABLE border=1><TR><TH>得点</TH><TH>問題数</TH><TH>解答日時</TH><TH>時間(秒)</TH>\n");
			$val = split(",", $data[0]); // カンマで分割
			$j = count($val);
			for ($i=6; $i < $j-1; $i=$i+2)  // 問題番号を出力
			print("<TH>" . ($i-4)/2 . "</TH>");
			print("</TR>\n");
			for ($i = 0; $i < $n-1; $i++) {
				$val = split(",", $data[$i]); // カンマで分割
				print("<TR><TD align='center'>$val[2]</TD><TD align='center'>$val[3]</TD><TD>$val[4]</TD><TD align='right'>$val[5]</TD>");
				for ($k = 6; $k< $j-1; $k=$k+2) {
					print("<TD align='center'>" . $val[$k]);  // 生徒の解答
					if ($val[$k+1] == "○") // 正解
					print("<BR><FONT color='BLUE'>○</FONT></TD>");
					else                    // 間違い
					print("<BR><FONT color='RED'>×</FONT></TD>");
				}
				print("</TR>\n");
			}
			print("</TABLE>\n");
		}
	}
}

print_header("小テスト");
if (!isset($_SESSION['id']) || ($_SESSION['id'] == "")) { // ログインしていない
	print("<SCRIPT language='JavaScript'>");
	print("window.alert('ログインしてください');");
	print("</SCRIPT>");
	print("<CENTER><A href='../main/index.php'>ログインページへ</A></CENTER>");
} else {
	print_headline("成績");
	?>
<FORM method="POST" action="score.php">
<CENTER><?php
$i = 1;
while(file_exists("q" . $i)) $i++;
print_title1("第 $i 回小テスト");

$scorefile = "doc/" . $_SESSION['id'];
print_score($scorefile);

//  現在の小テストは解答を見せない
//
//      print("<H4>問題，正解，解説</H4>");
//      quiz_preview("doc/", "doc/quiz.csv");  // 問題、正解、解説の表示

print_title2("過去の成績");
?> <?php
$path = 0;
$i = 1;
while(file_exists("q" . $i)) {
	$x = "q" . $i;
	if (isset($_POST[$x])) $path = $i;
	print('<INPUT type="submit" value="第' . $i . '回" name="' .$x. '"> 　');
	$i++;
}
if ($path > 0) {
	$x = "q" . $path;
	print("<H4>第" . $path . "回小テスト</H4>");
	$scorefile = $x . "/" .$_SESSION['id'];
	print_score($scorefile);   // 成績の表示
	print("<H4>問題，正解，解説</H4>");
	quiz_preview($x . "/", $x . "/quiz.csv");  // 問題、正解、解説の表示
}
?></CENTER>
</FORM>
<?php
} print_copyright();
?>

</BODY>
</HTML>
