<?php
session_start();
include("../param.inc");

//       全員の成績を表示 
function save_allscore($path) {
	global $no, $uid;

	$n = count($no);   //  ユーザ数
	$data = NULL;
	for ($i=0; $i<$n; $i++) {
		$scorefile = "$path/" . $uid[$i];
		if (file_exists($scorefile)) {
			$fp = fopen($scorefile, "r");
			while ($tmp = fgets($fp, 4096)) $data[] = $tmp;  // 成績を取り込む
			fclose($fp);
		}
	}
	$n = count($data);
	if ($n > 0) {  // 成績があれば
		usort($data, "sort_by_no");  // 出席番号順にソート
		if (isset($_POST[$path])) {  // 保存ボタンが押されたら
			$fp = fopen($path . "/tmp.csv", "w");
			$header = "番号,氏名,得点,問題数,解答日時,時間(秒),";
			$val = split(",", $data[0]); // カンマで分割
			$j = count($val);
			for ($i=6; $i < $j-1; $i=$i+2)  // 問題番号を出力
			$header = $header . ($i-4)/2 . ",,";
			$header = $header . "\n";
			fputs($fp, mb_convert_encoding($header,"SJIS","auto"));
			for ($i = 0; $i<$n; $i++)
			fputs($fp, mb_convert_encoding($data[$i],"SJIS","auto"));
			fclose($fp);
			print('<DIV align="right">ダウンロード：<A href="' . $path . '/tmp.csv">成績ファイル</A></DIV>' . "\n");
		}
		// 成績表を表示 
		print("<TABLE border=1><TR><TH>番号</TH><TH>氏名</TH><TH>得点</TH><TH>問題数</TH><TH>解答日時</TH><TH>時間(秒)</TH>\n");
		$val = split(",", $data[0]); // カンマで分割
		$j = count($val);
		for ($i=6; $i < $j-1; $i=$i+2)  // 問題番号を出力
		print("<TH>" . ($i-4)/2 . "</TH>");
		print("</TR>\n");
		for ($i = 0; $i < $n; $i++) {
			$val = split(",", $data[$i]); // カンマで分割
			print("<TR><TD align='center'>$val[0]</TD><TD>$val[1]</TD><TD align='center'>$val[2]</TD><TD align='center'>$val[3]</TD><TD>$val[4]</TD><TD align='right'>$val[5]</TD>\n");
			for ($k = 6; $k< $j-1; $k=$k+2) {
				print("<TD align='center'>" . $val[$k]);  // 生徒の解答
				if ($val[$k+1] == "○") // 正解
				print("<BR><FONT color='BLUE'>○</FONT></TD>");
				else                    // 間違い
				print("<BR><FONT color='RED'>×</FONT></TD>");
			}
			print("</TR>\n");
		}
		print("</TABLE>\n");
	} else print_error("成績がありません");
}

print_header("小テスト");
if (!isset($_SESSION['id']) || ($_SESSION['id'] == "")) { // ログインしていない
	print("<SCRIPT language='JavaScript'>");
	print("window.alert('ログインしてください');");
	print("</SCRIPT>");
	print("<CENTER><A href='../main/index.php'>ログインページへ</A></CENTER>");
} else if ($_SESSION['admin']==0) { // 管理者でない
	print("<SCRIPT language='JavaScript'>");
	print("window.alert('あなたは管理者ではありません');");
	print("</SCRIPT>");
} else {
	print_headline("締切り後の成績の保存");
	?>
下のボタンをクリックすると，q?/tmp.csv ファイルを作成します。
<BR>
たとえば，q1/tmp.csv は第１回小テストの成績ファイルです。

<FORM method="POST" action="score_listup.php">
<CENTER><?php
print_title1("過去の成績");

$path = 0;
for ($i=1; $i<=20; $i++) {
	$x = "q" . $i;
	if (is_dir($x)) {
		if (isset($_POST[$x])) $path = $i;
		print('<INPUT type="submit" value="第' . $i . '回" name="' .$x. '">　');
	}
}
if ($path > 0) {
	print("<H4>第 $path 回</H4>\n");
	save_allscore("q". $path);
}
?></CENTER>
</FORM>
<?php
} print_copyright();
?>

</BODY>
</HTML>
